import 'package:admin_desktop/domain/models/response/booking_count_statistic_response.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

import '../../../../../../infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/presentation/components/custom_line.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class StatisticCheckTable extends StatelessWidget {
  final String status;
  final Booked? data;

  const StatisticCheckTable({
    super.key,
    required this.status,
    required this.data,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        CustomLine(),
        10.verticalSpace,
        Table(
          columnWidths: {
            0: FixedColumnWidth(80),
            1: FixedColumnWidth(70),
            2: FixedColumnWidth(70),
            3: FixedColumnWidth(80),
          },
          children: [
            TableRow(children: [
              Text(
                AppHelpers.getTranslation(status),
                style: Style.interRegular(size: 14),
              ),
              Text(
                "${data?.count ?? 0}",
                style: Style.interRegular(size: 14),
                textAlign: TextAlign.center,
              ),
              Text(
                "${data?.percent ?? 0}",
                style: Style.interRegular(size: 14),
                textAlign: TextAlign.center,
              ),
              Text(
                AppHelpers.numberFormat(number: data?.totalPrice),
                style: Style.interRegular(size: 14),
                textAlign: TextAlign.end,
              ),
            ]),
          ],
        ),
        8.verticalSpace,
      ],
    );
  }
}
